<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Reservation extends Model 
{

    protected $table = 'con_reservations';
    public $timestamps = true;
    protected $fillable = array('user_id', 'start_date', 'finish_date', 'expert_id', 'canceled_at', 'canceled_by', 'status', 'package_id', 'service_id', 'host_id');

    public function package()
    {
        return $this->belongsTo('Package');
    }

    public function service()
    {
        return $this->belongsTo('Service');
    }

    public function host()
    {
        return $this->belongsTo('Host');
    }

}